import readline from "readline";
import { loadDatabases } from "./databases/loadDatabases";
import { Database } from "./databases/Database";

async function main() {
  const databaseClasses = await loadDatabases(); // 📌 Pobieramy klasy baz danych
  const rl = readline.createInterface({ input: process.stdin, output: process.stdout });

  console.log("\n📌 Wybierz bazę danych:");
  Object.keys(databaseClasses).forEach((db, i) => console.log(`${i + 1}. ${db}`));

  rl.question("\n✏️  Wpisz numer bazy: ", async (answer) => {
    const choice = Object.keys(databaseClasses)[parseInt(answer) - 1];
    if (!choice) {
      console.log("❌ Niepoprawny wybór!");
      rl.close();
      return;
    }

    const SelectedDB = databaseClasses[choice]; // 📌 Pobieramy klasę wybranej bazy
    const config = await askForConfig(rl, choice); // 📌 Pytamy o konfigurację

    const db: Database = new SelectedDB(config); // 📌 Teraz dopiero tworzymy instancję

    try {
      await db.connect();
      await db.insert("users", { name: "Alice", age: 25 });
      const user = await db.get("users", "1");
      console.log(`📊 Dane z ${choice}:`, user);
    } catch (error) {
      console.error(`❌ Błąd podczas obsługi bazy ${choice}:`, error.message || error);
    }

    rl.close();
  });
}

// 📌 Funkcja do pytania użytkownika o konfigurację
function askForConfig(rl: readline.Interface, dbName: string): Promise<any> {
  return new Promise((resolve) => {
    if (dbName === "MongoDB") {
      rl.question("\n🔗 Podaj URI MongoDB: ", (uri) => resolve(uri || "mongodb://localhost:27017/testdb"));
    } else if (dbName === "RedisJSON") {
      rl.question("\n📌 Podaj host Redis: ", (host) => {
        rl.question("\n📌 Podaj port Redis: ", (port) => resolve({ host, port: parseInt(port) || 6379 }));
      });
    } else if (dbName === "PGJSONB") {
      rl.question("\n🔗 Podaj URI PostgreSQL: ", (uri) => resolve(uri || "postgresql://user:password@localhost:5432/testdb"));
    } else {
      resolve({});
    }
  });
}

main();
