import { Database } from "./Database";

// 📂 Lista dostępnych baz danych (bez konfiguracji!)
const databaseModules = [
  () => import("./MongoDB"),
//  () => import("./RedisJSON"),
//  () => import("./PGJSONB"),
];

async function loadDatabases(): Promise<{ [key: string]: typeof Database }> {
  const dbClasses: { [key: string]: typeof Database } = {};

  for (const loadModule of databaseModules) {
    try {
      const module = await loadModule();
      console.log("✅ Załadowany moduł:", module); // 🔥 Debugowanie
      const DBClass = module.default as typeof Database;

      if (!DBClass) {
        console.error("❌ Błąd: `module.default` jest `undefined`!");
        continue;
      }

      if (typeof DBClass.getName === "function") {
        dbClasses[DBClass.getName()] = DBClass; // 👈 Zwracamy klasę, nie instancję
      }
    } catch (error) {
      console.error("❌ Błąd ładowania bazy danych:", error);
    }
  }

  return dbClasses;
}

export { loadDatabases };
