import mongoose from "mongoose";
import { Database } from "./Database";

export default class MongoDB extends Database {
  private uri: string;

  constructor(uri: string) {
    super();
    this.uri = uri;
  }

  async connect(): Promise<void> {
    await mongoose.connect(this.uri);
    console.log("🔗 MongoDB connected");
  }

  async authenticate(username: string, password: string): Promise<boolean> {
    return username === "admin" && password === "secret"; // Tu można dodać logikę JWT lub kolekcję users
  }

  async insert(collection: string, data: any): Promise<void> {
    const model = mongoose.model(collection, new mongoose.Schema({}, { strict: false }));
    await model.create(data);
    console.log(`📥 Inserted into ${collection}`);
  }

  async update(collection: string, id: string, data: any): Promise<void> {
    const model = mongoose.model(collection, new mongoose.Schema({}, { strict: false }));
    await model.findByIdAndUpdate(id, data);
    console.log(`📝 Updated ${id} in ${collection}`);
  }

  async delete(collection: string, id: string): Promise<void> {
    const model = mongoose.model(collection, new mongoose.Schema({}, { strict: false }));
    await model.findByIdAndDelete(id);
    console.log(`🗑 Deleted ${id} from ${collection}`);
  }

  async get(collection: string, id: string): Promise<any> {
    const model = mongoose.model(collection, new mongoose.Schema({}, { strict: false }));
    return model.findById(id);
  }

  static getName(): string {
    return "MongoDB";
  }
}
