export abstract class Database {
  abstract connect(): Promise<void>;
  abstract insert(collection: string, data: any): Promise<void>;
  abstract update(collection: string, id: string, data: any): Promise<void>;
  abstract delete(collection: string, id: string): Promise<void>;
  abstract get(collection: string, id: string): Promise<any>;

  protected onError(error: any, operation: string) {
    console.error(`❌ Błąd podczas operacji "${operation}":`, error.message || error);
  }

  static getName(): string {
    throw new Error("getName() must be implemented in subclasses");
  }
}
